library(tidyverse)




load("results/real_1.RData")
load("results/real_2.RData")

#Figure 5a for Trial I

matrix_1 <- matrix(0,9,4)
matrix_1[1:9,1]<-rep(c(0,1,2),times=3)
matrix_1[1:9,4]<-rep(c(1,2,3),each=3)
matrix_1[1:9,2:3] <- all_ci_1

matrix_1 <- as.data.frame(matrix_1)

matrix_1[matrix_1$V4==1,4] = "1"
matrix_1[matrix_1$V4==2,4] = "2"
matrix_1[matrix_1$V4==3,4] = "3"

matrix_1$title <- "Trial I"

p1 <- ggplot(data = matrix_1,aes(x = V1, y = (V2+V3)/2, ymin = V2, ymax =V3,color=V4,shape=V4)) +
  scale_x_continuous(breaks=seq(0, 2, 1))+
  geom_point(position=position_dodge(width=0.5),size=5) +
  geom_errorbar(position=position_dodge(width=0.5), size =2,width=0.5) +
  scale_color_manual(name=NULL,
                     labels=c("Mixed (w/o time)","Mixed (w/ time)","MCRTs+Z"),
                     values=c("#619CFF","#00BA38","#F8766D"))+
  #scale_shape_manual(name = NULL, values = c("Mixed (w/o time)" =19, "Mixed (w/ time)"= 17, "MCRTs+Z" = 15))+
  scale_y_continuous(breaks = seq(-2, 4, by = 1)) + 
  facet_grid(. ~ title)+
  xlab("Time lag") +
  ylab("Effect on quality of life")
p1 <- p1 + theme_bw(base_line_size =0.5,base_rect_size = 1.0)

p1 <-p1 + theme(
  aspect.ratio=9/10,
  legend.position="none",
  text = element_text(size=32, face="bold"),
  axis.title.x = element_text(color="black", size=32, face="bold",vjust = -2),
  axis.title.y = element_text(color="black", size=32, face="bold",vjust = 5),
  plot.margin=unit(c(1,1,1,1),"cm"))

ggsave(p1, width = 6, height = 6, dpi = 300, filename =paste("figures/real/real_1.png"))




#Figure 5b for Trial II


matrix_2 <- matrix(0,12,4)
matrix_2[1:12,1]<-rep(c(0,1,2,3),times=3)
matrix_2[1:12,4]<-rep(c(1,2,3),each=4)
matrix_2[1:12,2:3] <- all_ci_2

matrix_2 <- as.data.frame(matrix_2)

matrix_2[matrix_2$V4==1,4] = "1"
matrix_2[matrix_2$V4==2,4] = "2"
matrix_2[matrix_2$V4==3,4] = "3"


matrix_2$title <- "Trial II"

p2 <- ggplot(data = matrix_2,aes(x = V1, y = (V2+V3)/2, ymin = V2, ymax =V3,color=V4,shape=V4)) +
  scale_x_continuous(breaks=seq(0, 3, 1))+
  geom_point(position=position_dodge(width=0.5),size=5) +
  geom_errorbar(position=position_dodge(width=0.5), size =2,width=0.5) +
  scale_color_manual(name=NULL,
                     labels=c("Mixed (w/o time)","Mixed (w/ time)","MCRTs+Z"),
                     values=c("#619CFF","#00BA38","#F8766D"))+
  #scale_shape_manual(name = NULL, values = c("Mixed (w/o time)" =19, "Mixed (w/ time)"= 17, "MCRTs+Z" = 15))+
  facet_grid(. ~ title)+
  xlab("Time lag") +
  ylab("Effect on chronic pain")
p2 <- p2 + theme_bw(base_line_size =0.5,base_rect_size = 1.0)

p2 <-p2 + theme(
  aspect.ratio=9/10,
  legend.position="none",
  text = element_text(size=32, face="bold"),
  axis.title.x = element_text(color="black", size=32, face="bold",vjust = -2),
  axis.title.y = element_text(color="black", size=32, face="bold",vjust = 5),
  plot.margin=unit(c(1,1,1,1),"cm"))

ggsave(p2, width = 6, height = 6, dpi = 300, filename =paste("figures/real/real_2.png"))








