function r  = nylonfn1(t,y,params,fn_extras)
%
% This is a 4 parameter version of the model from:
% Wei Zheng, Kim B. McAuley, E. Keith Marchildon and
% Yao K. Zhen, 2005, "Effects of End-Group Balance on Melt-Phase Nylon 612
% Polycondensation: Experimental Study and Mathematical Model", Ind. Eng. Chem. Res.
%  vol 44, p 2675 - 2686
%
% y has columns A C W and rows are for time
% 
%pars = [K_p0, gamma, Ka0,  deltaH ]
% 
constants    = [549, 24.3, 20.97, 647.3, 165376,8.3145e-3];
% constants = [T_0, k_m,gamma_w0,Tc,Pc,R]
%                       1    2       3             4   5  6
%
T = fn_extras(1);
W_eq = fn_extras(2);
A = y(1);
C = y(2);
W = y(3);
exp_multiplier=1/constants(6)*(1/T-1/constants(1));

kp=params(1)/1000;
gamma_w = exp(9.624-3613/T);
K_a = (1+params(2)/1e3*W_eq)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);

L = nylon_L(A,C,W);
r=ones(size(y));

r(1) = -kp*(A*C-L*W/K_a);
r(2) = r(1);
r(3) = -r(1)-constants(2)*(W-W_eq);