function dfdy  = nylondfdy(t,fd_cell,params,fn_extras)
% Nylon612 equations 
% derivatives with respect to outputs
%
% This is a 4 parameter version of the model from:
% Wei Zheng, Kim B. McAuley, E. Keith Marchildon and
% Yao K. Zhen, 2005, "Effects of End-Group Balance on Melt-Phase Nylon 612
% Polycondensation: Experimental Study and Mathematical Model", Ind. Eng. Chem. Res.
%  vol 44, p 2675 - 2686
%
% y has columns A C W and rows are for time
% 
%pars = [K_p0, gamma, Ka0,  deltaH ]
% 
constants    = [549, 24.3, 20.97, 647.3, 165376,8.3145e-3];
% constants = [T_0, k_m,gamma_w0,Tc,Pc,R]
%                       1    2       3             4   5  6
%
T = fn_extras{1};
W_eq = eval_fd(t,fn_extras{2});
y = eval_fdcell(t,fd_cell);
A = y{1};
C = y{2};
W = y{3};
L = nylon_L(A,C,W);
exp_multiplier=1/constants(6)*(1/T-1/constants(1));

kp=params(1)/1000;
gamma_w = exp(9.624-3613/T);
K_a = (1+params(2)/1e3*W_eq)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);

dLdA = (-58.10)/155.23;
dLdC = (- 115.15)/155.23;
dLdW = (-18.02)/155.23;
dfdy=cell(3,3);

dfdy{1,1}=-kp.*(C-dLdA.*W./K_a);% d(eq4)/d[A] where eq4 is equation #4 in the Zheng et al paper
dfdy{1,2}=-kp.*(A-dLdC.*W./K_a);% d(eq4)/d[C]
dfdy{1,3}=kp./K_a.*(dLdW.*W+L);% d(eq4)/d[W]

dfdy{2,1}=dfdy{1,1};% d /d[A]
dfdy{2,2}=dfdy{1,2};% d/d[C]
dfdy{2,3}=dfdy{1,3};% d/d[W]

dfdy{3,1}=-dfdy{1,1};
dfdy{3,2}=-dfdy{1,2};
dfdy{3,3}=-dfdy{1,3}-constants(2);
