function dfdpar  = nylondfdpar(t,fd_cell,params,fn_extras)
% Nylon612 equations 
%
% This is a 4 parameter version of the model from:
% Wei Zheng, Kim B. McAuley, E. Keith Marchildon and
% Yao K. Zhen, 2005, "Effects of End-Group Balance on Melt-Phase Nylon 612
% Polycondensation: Experimental Study and Mathematical Model", Ind. Eng. Chem. Res.
%  vol 44, p 2675 - 2686
%
%
% y has columns A C W and rows are for time
% 
%pars = [K_p0, gamma, Ka0,  deltaH ]
% 
constants    = [549, 24.3, 20.97, 647.3, 165376,8.3145e-3];
% constants = [T_0, k_m,gamma_w0,Tc,Pc,R]
%                       1    2       3             4   5  6
%
T = fn_extras{1};
W_eq = eval_fd(t,fn_extras{2});
y = eval_fdcell(t,fd_cell);
A = y{1};
C = y{2};
W = y{3};
L = nylon_L(A,C,W);

exp_multiplier=1/constants(6)*(1/T-1/constants(1));
kp=params(1)/1000;
gamma_w = exp(9.624-3613/T);
K_a = (1+params(2)/1e3*W_eq)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);

dkpdk_p0    = kp/params(1);

dK_adK_a0   = K_a/params(3);
dK_adg      = (W_eq/1e3)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);
dK_addeltaH = -exp_multiplier*K_a;


dfdpar=cell(3,4);

dfdpar{1,1}=-dkpdk_p0*(C.*A-L.*W./K_a);
dfdpar{1,2}=-kp*(L.*W./K_a.^2).*dK_adg;
dfdpar{1,3}=-kp*(L.*W./K_a.^2).*dK_adK_a0;
dfdpar{1,4}=-kp*(L.*W./K_a.^2).*dK_addeltaH;

dfdpar{2,1}=dfdpar{1,1};
dfdpar{2,2}=dfdpar{1,2};
dfdpar{2,3}=dfdpar{1,3};
dfdpar{2,4}=dfdpar{1,4};

dfdpar{3,1}=-dfdpar{1,1};
dfdpar{3,2}=-dfdpar{1,2};
dfdpar{3,3}=-dfdpar{1,3};
dfdpar{3,4}=-dfdpar{1,4};
