function d3fdydp2  = nylond3fdydp2(t,fd_cell,params,fn_extras)
% Nylon612 equations 
%
% This is a 4 parameter version of the model from:
% Wei Zheng, Kim B. McAuley, E. Keith Marchildon and
% Yao K. Zhen, 2005, "Effects of End-Group Balance on Melt-Phase Nylon 612
% Polycondensation: Experimental Study and Mathematical Model", Ind. Eng. Chem. Res.
%  vol 44, p 2675 - 2686
%
% y has columns A C W and rows are for time
% 
%pars = [K_p0, gamma, Ka0,  deltaH ]
% 
constants    = [549, 24.3, 20.97, 647.3, 165376,8.3145e-3];
% constants = [T_0, k_m,gamma_w0,Tc,Pc,R]
%                       1    2       3             4   5  6
%
T = fn_extras{1};
W_eq = eval_fd(t,fn_extras{2});
y = eval_fdcell(t,fd_cell);
A = y{1};
C = y{2};
W = y{3};
L = nylon_L(A,C,W);
dLdA = (-58.10)/155.23;
dLdC = (- 115.15)/155.23;
dLdW = (-18.02)/155.23;

exp_multiplier=1/constants(6)*(1/T-1/constants(1));
kp=params(1)/1000;
gamma_w = exp(9.624-3613/T);
K_a = (1+params(2)/1e3*W_eq)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);

dkpdk_p0    = kp/params(1);
d2kpdk_p02    = 0;
dK_adK_a0   = K_a/params(3);
d2K_adK_a02    = 0;
dK_adg      = (W_eq/1e3)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);
d2K_adg2       = 0;
d2K_adgdK_a0   = dK_adg/params(3);
dK_addeltaH = -exp_multiplier*K_a;
d2K_addeltaH2      = -exp_multiplier*dK_addeltaH ;
d2K_addeltaHdK_a0  = -exp_multiplier*dK_adK_a0;
d2K_addeltaHdg     = -exp_multiplier*dK_adg;
                                      
                 
d3fdydp2=cell(3,3,4,4); % with dims: equation, component, param, param

d3fdydp2{1,1,1,1}=-d2kpdk_p02*(C-dLdA.*W./K_a);
d3fdydp2{1,1,1,2}=-dkpdk_p0*(dLdA.*W./K_a.^2).*dK_adg;
d3fdydp2{1,1,1,3}=-dkpdk_p0*(dLdA.*W./K_a.^2).*dK_adK_a0;
d3fdydp2{1,1,1,4}=-dkpdk_p0*(dLdA.*W./K_a.^2).*dK_addeltaH;

d3fdydp2{1,1,2,1}=-dkpdk_p0*(dLdA.*W./K_a.^2).*dK_adg;
d3fdydp2{1,1,2,2}=-kp*(dLdA.*W./K_a.^2).*d2K_adg2+2*kp*(dLdA.*W./K_a.^3).*(dK_adg).^2;
d3fdydp2{1,1,2,3}=-kp*(dLdA.*W./K_a.^2).*d2K_adgdK_a0+2*kp*(dLdA.*W./K_a.^3).*dK_adg.*dK_adK_a0;
d3fdydp2{1,1,2,4}=-kp*(dLdA.*W./K_a.^2).*d2K_addeltaHdg+2*kp*(dLdA.*W./K_a.^3).*dK_adg.*dK_addeltaH;

d3fdydp2{1,1,3,1}=-dkpdk_p0*(dLdA.*W./K_a.^2).*dK_adK_a0;
d3fdydp2{1,1,3,2}=-kp*(dLdA.*W./K_a.^2).*d2K_adgdK_a0+2*kp*(dLdA.*W./K_a.^3).*dK_adK_a0.*dK_adg;
d3fdydp2{1,1,3,3}=-kp*(dLdA.*W./K_a.^2).*d2K_adK_a02+2*kp*(dLdA.*W./K_a.^3).*dK_adK_a0.^2;
d3fdydp2{1,1,3,4}=-kp*(dLdA.*W./K_a.^2).*d2K_addeltaHdK_a0+2*kp*(dLdA.*W./K_a.^3).*dK_adK_a0.*dK_addeltaH;

d3fdydp2{1,1,4,1}=-dkpdk_p0*(dLdA.*W./K_a.^2).*dK_addeltaH;
d3fdydp2{1,1,4,2}=-kp*(dLdA.*W./K_a.^2).*d2K_addeltaHdg+2*kp*(dLdA.*W./K_a.^3).*dK_addeltaH.*dK_adg;
d3fdydp2{1,1,4,3}=-kp*(dLdA.*W./K_a.^2).*d2K_addeltaHdK_a0+2*kp*(dLdA.*W./K_a.^3).*dK_addeltaH.*dK_adK_a0;
d3fdydp2{1,1,4,4}=-kp*(dLdA.*W./K_a.^2).*d2K_addeltaH2+2*kp*(dLdA.*W./K_a.^3).*dK_addeltaH.^2;

d3fdydp2{1,2,1,1}=-d2kpdk_p02.*(A-dLdC.*W./K_a);
d3fdydp2{1,2,1,2}=d3fdydp2{1,1,1,2}*(dLdC./dLdA);
d3fdydp2{1,2,1,3}=d3fdydp2{1,1,1,3}*(dLdC./dLdA);
d3fdydp2{1,2,1,4}=d3fdydp2{1,1,1,4}*(dLdC./dLdA);

for i =2:4
    for j=1:4
        d3fdydp2{1,2,i,j}=d3fdydp2{1,1,i,j}*dLdC/dLdA;
    end
end

d3fdydp2{1,3,1,1}=d2kpdk_p02./K_a.*(dLdW.*W+L);
d3fdydp2{1,3,1,2}=-dkpdk_p0./K_a.^2.*(dLdW.*W+L).*dK_adg;
d3fdydp2{1,3,1,3}=-dkpdk_p0./K_a.^2.*(dLdW.*W+L).*dK_adK_a0;
d3fdydp2{1,3,1,4}=-dkpdk_p0./K_a.^2.*(dLdW.*W+L).*dK_addeltaH;


for i=2:4
    for j=1:4
        d3fdydp2{1,3,i,j}=d3fdydp2{1,1,i,j}.*(dLdW.*W+L)./(dLdA.*W);
    end
end

d3fdydp2(2,:,:,:)=d3fdydp2(1,:,:,:);
 for i=1:size(d3fdydp2,2)
     for j=1:size(d3fdydp2,3)
         for k=1:size(d3fdydp2,4)
             d3fdydp2{3,i,j,k}=-d3fdydp2{1,i,j,k};
         end
     end
 end
