function d2fdydpar  = nylond2fdydpar(t,fd_cell,params,fn_extras)
% Nylon612 equations 
% Hessian with respect to parameters and outputs
%
% This is a 4 parameter version of the model from:
% Wei Zheng, Kim B. McAuley, E. Keith Marchildon and
% Yao K. Zhen, 2005, "Effects of End-Group Balance on Melt-Phase Nylon 612
% Polycondensation: Experimental Study and Mathematical Model", Ind. Eng. Chem. Res.
%  vol 44, p 2675 - 2686
%
% y has columns A C W and rows are for time
% 
%pars = [K_p0, gamma, Ka0,  deltaH ]
% 
constants    = [549, 24.3, 20.97, 647.3, 165376,8.3145e-3];
% constants = [T_0, k_m,gamma_w0,Tc,Pc,R]
%                       1    2       3             4   5  6
%
T = fn_extras{1};
W_eq = eval_fd(t,fn_extras{2});
y = eval_fdcell(t,fd_cell);
A = y{1};
C = y{2};
W = y{3};
L = nylon_L(A,C,W);
dLdA = (-58.10)/155.23;
dLdC = (- 115.15)/155.23;
dLdW = (-18.02)/155.23;

exp_multiplier=1/constants(6)*(1/T-1/constants(1));
kp=params(1)/1000;
gamma_w = exp(9.624-3613/T);
K_a = (1+params(2)/1e3*W_eq)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);

dkpdk_p0    = kp/params(1);

dK_adK_a0   = K_a/params(3);
dK_adg      = (W_eq/1e3)*(constants(3)/gamma_w)*params(3)*exp(-params(4)*exp_multiplier);
dK_addeltaH = -exp_multiplier*K_a;

d2fdydpar=cell(3,3,4);

d2fdydpar{1,1,1}=-dkpdk_p0*(C-dLdA.*W./K_a);%k_p0
d2fdydpar{1,1,2}=-kp*(dLdA.*W./K_a.^2).*dK_adg;% alpha
d2fdydpar{1,1,3}=-kp*(dLdA.*W./K_a.^2).*dK_adK_a0;% K_a0
d2fdydpar{1,1,4}=-kp*(dLdA.*W./K_a.^2).*dK_addeltaH;% deltaH

d2fdydpar{1,2,1}=-dkpdk_p0.*(A-dLdC.*W./K_a);%K_p0
d2fdydpar{1,2,2}=-(kp.*(dLdC.*W)./K_a.^2).*dK_adg;%alpha
d2fdydpar{1,2,3}=-(kp.*(dLdC.*W)./K_a.^2).*dK_adK_a0;%K_a0
d2fdydpar{1,2,4}=-(kp.*(dLdC.*W)./K_a.^2).*dK_addeltaH;%deltaH

d2fdydpar{1,3,1}=dkpdk_p0./K_a.*(dLdW.*W+L);%K_p0
d2fdydpar{1,3,2}=-(kp./K_a.^2).*dK_adg.*(dLdW.*W+L);%alpha
d2fdydpar{1,3,3}=-(kp./K_a.^2).*dK_adK_a0.*(dLdW.*W+L);%K_a0
d2fdydpar{1,3,4}=-(kp./K_a.^2).*dK_addeltaH.*(dLdW.*W+L);%deltaH

d2fdydpar(2,:,:)=d2fdydpar(1,:,:); % because dA/dt=dC/dt

for i=1:size(d2fdydpar,2)
    for j=1:size(d2fdydpar,3)
        d2fdydpar{3,i,j}=-d2fdydpar{1,i,j}; % because dW/dt=-dA/dt-function of W_eq
    end
end
