function L = nylon_L(A,C,W)
%
% Compute nylon concentration as a function of the concentrations of A,C and W.
% This equation is from:
% Wei Zheng, Kim B. McAuley, E. Keith Marchildon and
% Yao K. Zhen, 2005, "Effects of End-Group Balance on Melt-Phase Nylon 612
% Polycondensation: Experimental Study and Mathematical Model", Ind. Eng. Chem. Res.
%  vol 44, p 2675 - 2686

L = (1e6 - 115.15*C-58.10*A-18.02*W)/155.23;
