% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/core.R
\name{get.weights}
\alias{get.weights}
\title{A new version of PS.weights}
\usage{
get.weights(label, features, type = c("pop", "nr"), method = c("glm",
  "glmnet", "gbm", "cbps", "ebal", "unif", "mmcb"), ...)
}
\arguments{
\item{label}{labels, 0 for control and 1 for treatment}

\item{features}{covaraites to be used in propensity scoring}

\item{type}{either "pop" (full population) or "nr" (non-respondents).
If the input is a factor level,
it will be automatically transformed into a character string.}

\item{method}{various propensity scoring methods}

\item{...}{additional parameters for glmnet and gbm.}
}
\value{
a list of \describe{
  \item{model}{the model used.}
  \item{weights}{estimated weights}
  \item{propensity.score}{estimated propensity score}
  \item{method}{method used}
}
}
\description{
This returns the weights in the general framework
             described in Kang&Schaffer (2007)
}
\details{
If type="nr", this function only weights the control units.
}
\references{
Lunceford & Davidian, Stratification and Weighting
  Via the Propensity Score in Estimation of
  Casual Treatment Effects: A Comparative Study,
  2004;
  Kang & Schaffer, Demystifying Double Robustness:
  A Comparison of Alternative Strategies
  for Estimating a Population Mean from Incomplete Data,
  2007
}

