% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sim_funs.R
\name{generate.synthetic.data}
\alias{generate.synthetic.data}
\title{Simulate data set}
\usage{
generate.synthetic.data(n, p = 2, setting = NULL, t.model = c("logistic",
  "normal", "loglinear"), t.model.x = c("linear", "quadratic", "cubic"),
  y.model = c("linear", "quadratic", "cubic"), t.param = c(0, rep(1, p)),
  y0.param = c(-2, rep(0.2, p)), y1.param = c(-2, rep(-2, p)),
  sigma0 = 0.2, sigma1 = 0.2, sigma.normal = 5, quadratic.offset = 1)
}
\arguments{
\item{n}{number of data points}

\item{p}{number of covariates}

\item{setting}{(optional) a list (or named vector) of all the arguments}

\item{t.model}{propensity score model, see Details}

\item{t.model.x}{model on X before t.model, see Details}

\item{y.model}{outcome model, see Details}

\item{t.param}{parameters in t.model}

\item{y0.param}{parameters in y.model for Y0}

\item{y1.param}{parameters in y.model for Y1}

\item{sigma0}{noise level in y.model for Y0, see Details}

\item{sigma1}{noise level in y.model for Y1, see Details}

\item{sigma.normal}{noise level for the "normal" propensity score model}

\item{quadratic.offset}{the offset if t.model.x or y.model is quadratic,
see deatils (will appear as qo)}
}
\value{
a "obdata" object
}
\description{
Simulate data set
}
\details{
The data is generated by the following models
\itemize {
\item t.mode.x = "linear": logit.true = X * theta; \cr
               = "quadratic": logit.true = (X+qo)^2 * theta; \cr
               = "cubic": logit.true = X^3 * theta; \cr
\item t.model = "logistic": logit(P(T=1)) = logit.true; \cr
              = "normal": T = (logit.true + sigma.norm * rnorm(n) > 0); \cr
              = "loglinear": log(P(T=1)) = logit.true; \cr
\item y.model = "linear: Y(0) = X * beta; \cr
              = "quadratic" : Y(0) = (X+qo)^2 * beta; \cr
              = "cubic": Y(0) = X^3 * beta; \cr
Y(1) and Y are always the same: \cr
Y(1) = 2 * Y(0) + 1 + sigma * N(0,1); \cr
Y = T * Y(1) + (1-T) * Y(0); \cr
}
}

