S.func <- function(f, alpha, beta) {
    n <- length(f)
    prob <- link(f)
    S <- rep(0, length(f))
    for (i in 1:length(prob)) {
        S[i] <- integrate(function(p) (T[i] - p) * p^(alpha - 1) * (1 - p)^(beta - 1), lower = 1/2, upper = prob[i])$value
    }
    sum(S) / n
}

S.prime <- function(f, alpha, beta) {
    prob <- link(f)
    (T - prob) * prob^alpha * (1 - prob)^beta
}

S.prime.prime <- function(f, alpha, beta) {
    p <- link(f)
    T * (alpha * p^alpha * (1 - p)^(beta + 2) - (beta + 1) * p^(alpha + 1) * (1 - p)^(beta + 1)) +
        (1 - T) * (beta * (1 - p)^beta * p^(alpha + 2) - (alpha + 1) * (1 - p)^(beta + 1) * p^(alpha + 1))
}

link <- function(f) {
    1 / (1 + exp(-f))
}
