% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/core.R
\name{get.mean}
\alias{get.mean}
\title{Estimate mean}
\usage{
get.mean(T, Y, features, features.T = features, features.Y = features,
  over = c("treated", "all"), T.method = c("glm", "unif", "glmnet", "cbps",
  "ebal", "mmcb"), weight.type = c("pop", "nr"), Y.method = c("lm", "none",
  "wls"), combine.method = c("dr", "none"), T.model = NULL,
  Y.model = NULL)
}
\arguments{
\item{T}{treatment (1) or control (0)}

\item{Y}{outcome}

\item{features}{features}

\item{features.T}{features to be used in T.model (optional)}

\item{features.Y}{features to be used in Y.model (optional)}

\item{over}{either "treated" (E[Y(0)|T=1]) or "all" (E[Y(0)])
If the input is a factor level,
it will be automatically transformed into a character string.}

\item{T.method}{weighting method (usually based on propensity score)}

\item{Y.method}{outcome regression method}

\item{combine.method}{combining method}

\item{T.model}{a fitted propensity model (optional)}

\item{Y.model}{a fitted outcome model on the control (optional)}
}
\value{
\describe {
  \item{mean.est}{the mean estimate}
  \item{T.model}{the propensity score model}
  \item{Y.model}{the outcome model}
}
}
\description{
estimate E[Y(0)] or E[Y(0)|T=1]
}
\details{
The weights are always normalized.
         In the usual causal effect model, Y = T * Y(1) + (1-T) * Y(0).
         \code{get.mean} only estimates the mean of Y(0), so it treats
         Y[T==1] as unobserved response.
}

