% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/core.R
\name{get.effect}
\alias{get.effect}
\title{Estimate causal effect}
\usage{
get.effect(T, Y, features, features.T = features, features.Y = features,
  effect = c("ATT", "ATE"), T.method = c("glm", "unif", "glmnet", "cbps",
  "ebal", "mmcb"), weight.type = c("pop", "nr"), Y.method = c("lm", "none",
  "wls"), combine.method = c("dr", "none"))
}
\arguments{
\item{T}{treatment (1) or control (0)}

\item{Y}{outcome}

\item{features}{features}

\item{features.T}{features to be used in T.model (optional)}

\item{features.Y}{features to be used in Y.model (optional)}

\item{effect}{ATT or ATE}

\item{T.method}{weighting method (usually based on propensity score)}

\item{Y.method}{outcome regression method}

\item{combine.method}{combining method}
}
\value{
\describe {
  \item{effect.est}{the causal effect estimate}
  \item{mean}{the mean estimates}
  \item{m0}{model for control response}
  \item{m1}{model for treatment response}
  \item{T.model}{propensity score model}
}
}
\description{
estimate E[Y(1)] - E[Y(0)] or E[Y(1)|T=1] - E[Y(0)|T=1]
}

