% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/old.R
\name{PS.weights}
\alias{PS.weights}
\title{A wrapper that returns weights based on different propensity score estimates.}
\usage{
PS.weights(class, features, effect = c("treated", "overall"),
  method = c("glm", "glmnet", "gbm", "cbps", "ebal", "unif"),
  improved = FALSE, ...)
}
\arguments{
\item{class}{labels (0 or 1)}

\item{features}{covaraites to be used in propensity scoring}

\item{effect}{either "treated" (treatment effect over treated) or "overall"}

\item{method}{various propensity scoring methods}

\item{improved}{if true, use the IPW3 method described in the reference.
Only available if method = "overall".}
}
\value{
a list of \describe{
  \item{model}{the model used.}
  \item{weights}{estimated weights}
  \item{propensity.score}{estimated propensity score}
  \item{method}{method used}
}
}
\description{
A wrapper that returns weights based on different propensity score estimates.
}
\references{
Lunceford & Davidian, Stratification and Weighting
  Via the Propensity Score in Estimation of
  Casual Treatment Effects: A Comparative Study
  2004
}

