#' #' Imbalance score of estimated propesntiy scores or weights
#' @export
#' @param X covaraite matrix
#' @param class class labels (0 or 1)
#' @param w a vector of estimated probability or weights
#' @param type either "prob" or "weight"
#' @param method if "centered", will use \code{scale} function first on \code{X}
#' @return the imbalance score defined in equation 20 in the reference
#' @references Imai and Ratkovic, Covariate Balancing Propensity Score,
#'             JRSSB, volume 76, 2014
imbalance.score <- function(w, X, class,
                            type = c("weight", "prob"),
                            method = c("centered", "original")) {
    # check arguments
    type <- match.arg(as.character(type), c("weight", "prob"))
    method <- match.arg(as.character(method), c("centered", "original"))

    if (method == "centered")
        X <- scale(X)
    if (type == "prob")
        w <- as.vector((class - w) / w / (1 - w))

    weighted.moments <- colMeans(X * w)
    t(weighted.moments) %*% solve(t(X) %*% X / nrow(X)) %*% weighted.moments
}

#' standardize a vector x to be min 0 and max 1.
range01 <- function(x) {
    (x - min(x)) / ( max(x) - min(x))
}
