forward.stepwise <- function(T, X, alpha, beta,
                             intercept = TRUE,
                             normalize = TRUE,
                             tol = 1e-6,
                             max.steps = min(length(T), ncol(X))) {

    max.steps <- min(max.steps, length(T), ncol(X))
    n <- length(T)
    m <- ncol(X)

    if (nrow(X) != n) {
        stop("The dimensions of T and X don't match.")
    }

    mm <- max.steps
    A <- matrix(FALSE, mm, m)
    A.current <- rep(FALSE, m)
    prob <- matrix(0, mm, n)

    model <- list(NULL)
    history <- rep(0, mm)

    for (j in 1:mm) {
        print(j)
        unadded <- which(!A.current)
        result <- tryCatch(lapply(unadded,
                                  function(k) {
                                      kernel.balance(T, cbind(X[, A.current], X[, k]),
                                                     alpha = alpha, beta = beta,
                                                     lambda = 0,
                                                     intercept = intercept,
                                            normalize = normalize,
                                                     tol = tol)
                                  }),
                           error = function(e) e)
        if (inherits(result, "error")) { # if there was an error
            message(result)
            break
        }
        new.var.ind <- which.max(sapply(result, function(x) x$S))
        A.current[unadded[new.var.ind]] <- TRUE
        history[j] <- unadded[new.var.ind]
        A[j, ] <- A.current
        model[[j]] <- result[[new.var.ind]]
    }

    if (intercept) {
        history <- c(0, history)
        A <- rbind(rep(0, m), A)
        p = T * mean(T) + (1 - T) * (1 - mean(T))
        model <- c(list(list(eta = rep(0, m + 1),
                        p = p,
                        converged = TRUE,
                        weights =
                            compute.weights(T, p,
                                            alpha = alpha, beta = beta, normalize = normalize))), model)
    }

    return(list(history = history,
                A = A,
                model = model))

}
